//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.5 page-716
//Topic      : Specific Energy; Critical Depth
//Caption    : A wide rectangular clean-earth

//===================================================
model Ex10_5

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real q(unit="ft^3/s") = 50 "Flow rate";

//===================================================

//Variable

Real yc(unit="ft") "Critical depth";

//===================================================

//Equation

equation

//USING: Eq. 10.30
yc=((q*q)/g)^0.3333;

//===================================================
end Ex10_5;
//===================================================
