//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.6 page-718
//Topic      : Specific Energy; Critical Depth
//Caption    : A triangular channel

//===================================================
package Ex10_6

extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex10_6_a

//Parameter
//GIVEN: Fig. E10.6
parameter Real ang(unit="deg.") = 50    "Angle of triangular channel";
parameter Real Q(unit="m^3/s") = 16     "Volumetric flow rate";
parameter Real n(unit="-") = 0.018      "Roughness factor";

//===================================================

//Variable

Real yc(unit="m") "Critical depth";

//===================================================

//Equation

equation

//USING: Eq. 10.37a
yc=((2*Q*Q/g)^(1/5))/((1/tan(ang*pi/180))^(2/5));

//===================================================
end Ex10_6_a;
//===================================================

model Ex10_6_b
extends Ex10_6_a;

//===================================================

//Variable

Real Pc(unit="m")   "Critical perimeter";
Real Rhc(unit="m")  "Critical hydraulic height";
Real Ac(unit="m^2") "Critical Area";
Real boc(unit="m")  "Critical width";
Real Vc(unit="m/s") "Critical velocity";

//===================================================

//Equation

equation

Pc=(2*yc)*((sin(ang*(pi/180)))^(-1));
Rhc=(0.5*yc)*(cos(50*(pi/180)));
Ac=(yc*yc)*((tan(ang*(pi/180)))^(-1));
boc=(2*yc)*((tan(ang*(pi/180)))^(-1));
Vc=(Q/Ac);

//===================================================
end Ex10_6_b;
//===================================================

model Ex10_6_c
extends Ex10_6_b;
extends Ex10_6_a;

//===================================================

//Variable

Real Sc(unit="-") "Critical slope";

//===================================================

//Equation

equation


Sc=((g)*(n^2)*(Pc))/((Rhc^0.3333)*(boc));

//===================================================
end Ex10_6_c;
//===================================================
end Ex10_6;
//===================================================
