//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.6 page-787
//Topic      : Matching Pumps to System Characteristics
//Caption    : 32in pump to pump water

//===================================================
model Ex11_6

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Fig. 11.7a
//Parameter
parameter Real D(unit="in") = 32        "Diameter of impeller";
parameter Real n(unit="r/min") = 1170   "Revolution";
parameter Real L(unit="ft") = 1500      "Length of pipe";
parameter Real D_pipe(unit="in") = 16   "Diameter of pipe";
parameter Real f(unit="-") = 0.030      "Friction factor pipe";
parameter Real z1(unit="ft") = 0        "Height of point-1";
parameter Real z2(unit="ft") = 120      "Height of point-2";


//Variable
Real Hs(unit="ft",start=400)    "Static head";
Real Q(unit="gal/min")          "Flow rate";

//Equation
equation
//SOLVING: Eq.2 and Eq.3
Hs=120+1.335*(Q/1000)^2;
Hs=490-(0.26*(Q/1000)^2);

//===================================================
end Ex11_6;
//===================================================
