//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.2 page-73
//Topic     : Hydrostatic Pressure Distributions
//Caption   : Compute the standard pressure

//===================================================
package Ex2_2
//===================================================
model Ex2_2_a

// Parameter

parameter Real ps(unit="Pa") = 101350       "Sea-Level pressure";
parameter Real alt(unit="m") = 5000         "Altitude";
parameter Real temp(unit="Deg.Cel") = 15    "Sea-Level temperature";
parameter Real B(unit="k/m") = 0.00650      "Lapse Rate";
parameter Real Dim(unit="Nil") = 5.26       "g/RB = 5.26(air), Dimensionless entity";
parameter Real g(unit="m/s^2") = 9.807      "Gravity Acceleration";
parameter Real R(unit="m^2/(s^2.k)") = 287  "Gas constant";

//===================================================
// Variable

Real p_abs(unit="Pa") "Absolute temperature using exact formula";
//===================================================
//Equation

equation

p_abs = ps*((1-((B*alt)/(temp+273.15)))^(Dim));
//===================================================
end Ex2_2_a;
//===================================================

//===================================================

model Ex2_2_b

extends Ex2_2_a;

extends Modelica.Math;
//===================================================
// Variable

Real p_iso(unit="Pa") "Pressure in atmostphere at isothermal condition";

//===================================================
//Equation

equation

p_iso = ps*exp(-((g*alt)/(R*(temp+273.15)))); //Atmosphere at isothermal condition

//===================================================
end Ex2_2_b;
//===================================================

//===================================================
end Ex2_2;
//===================================================

