//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.5 page-82
//Topic     : Hydrostatic Forces on Plane surfaces
//Caption   : Gate is hinged at a point 

//===================================================
package Ex2_5

model Ex2_5_a

// Parameter

parameter Real rho(unit="lbf/ft^3") = 64  "Sea water ensity";
parameter Real hCG(unit="ft") = 12      "Depth";
parameter Real w(unit="ft") = 5         "Gate width";
parameter Real len(unit="ft") = 10      "Gate length";


// Variable

Real A(unit="ft^2") "Area";
Real F(unit="lbf") "Hydrodynamic force on the gate";

//Equation

equation
A = (w*len);
F = (rho*hCG*A);


end Ex2_5_a;

//===================================================
model Ex2_5_b

extends Ex2_5_a;

extends Modelica.Math;

// Variable

Real Ixx(unit="ft^4") "Area moment of inertia";
Real l(unit="ft") "Inertial length";
Real P(unit="lbf") "Pressure about B";
Real len1(unit="ft") "Distance from point B";


//Equation

equation
Ixx = ((w*(len^3))/12);
l = ((Ixx*(6/10))/(hCG*A));
len1 = (len-l-w);
P = ((F*(w-l)))/(len*sin(36.86*(3.14/180))); //Angle = 1/(tan(6/8))= 36.86 , 6ft and 8ft from diagram.

end Ex2_5_b;
//===================================================
model Ex2_5_c

extends Ex2_5_a;
extends Ex2_5_b;

extends Modelica.Math;

// Variable

Real Bx(unit="lbf") "Force along x-direction";
Real Bz(unit="lbf") "Force along z-direction";

//Equation
equation
Bx = P-(F*(sin(36.86*(3.14/180)))); //Converting degree to radian
Bz = F*(cos(36.86*(3.14/180)));

end Ex2_5_c;

//===================================================

end Ex2_5;

//===================================================
