//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.14 page-175
//Topic     : Frictionless Flow: The Bernouli Equation
//Caption   : Water siphon.

//===================================================
model Ex3_14

//Parameter
parameter Real D(unit="cm") = 1 "Diameter of tube";
parameter Real z1(unit="cm") = 60 "Water level in container";
parameter Real z2(unit="cm") = -25 "Pipe outlet distance"; //Given in diagram
parameter Real z3(unit="cm") = 90 "Pipe height"; //Given in diagram
parameter Real z4(unit="cm") = 35 "Pipe opening distance"; //Give in diagram
parameter Real g(unit="m/s^2") = 9.81 "Gravity-acceleration";
//Variable
Real V2(unit="m/s") "Exit velocity from tube";
Real Q(unit="cm^3/s") "Volumetric flow rate";

//Equation
equation
V2=(((2*g)*((z1/100)-(z2/100)))^(0.5));
Q = (V2*(3.14/4)*((D/100)^2))*(10^6);

//===================================================
end Ex3_14;
//===================================================
