//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 4 : Differential Relations for Fluid Flow
//Example   : 4.4 page-237
//Topic     : The acceleration field of a fluid
//Captions  : Centrifugal impeller to pump hydrogen

//==========================================================

model Ex4_4
extends Modelica.Math;

//=================================
//Parameter 

parameter Real d(unit="cm")=40"Diameter of the impeller";
parameter Real T(unit="C")=15"Temperature with which hydrogen is pumped";
parameter Real R(unit="m^2/(s^2-K)")=4124"Gas constant";
parameter Real k(unit="")=1.41"Constant at T";

//=================================
//Variable 

Real a(unit="m/s")"Speed of sound";
Real Omega(unit="rev/min")"Speed of the impeller";

//=================================
//Equation

equation

a=sqrt(k*R*(T+273));
Omega=((0.3*a)/((d*1e-2)/2))*(9.5493);

//==========================================================
end Ex4_4;
//==========================================================
