//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 5 : Dimensional Analysis and Similarity
//Example   : 5.1 page-295
//Topic     : Introduction
//Caption   : A copepod is a water crustacean.

//===================================================
model Ex5_1

//Parameter
parameter Real d(unit="mm") = 1     "Diameter of water crustacean";
parameter Real Vm(unit="cm/s") = 30 "Velocity-model";
parameter Real Fm(unit="N") = 1.3   "Drag force-model";

//Given: TABLE A.3 properties at 20deg.C
parameter Real mewp(unit="kg/m.s") = 0.001  "Viscosity-water";
parameter Real mewm(unit="kg/m.s") = 1.5    "Viscosity-glycerine";
parameter Real rhop(unit="kg/m^3") = 998    "Density-water(prototype)";
parameter Real rhom(unit="kg/m^3") = 1263 "Density-glycerine(model)";

//Length scales assumed
parameter Real Lm(unit="mm") = 100  "Length-model";
parameter Real Lp(unit="mm") = 1    "Length-prototype";

//===================================================

//Variable
Real Re_model(unit="-") "Reynolds number-model";
Real Re_proto(unit="-") "Reynolds number-proto";
Real Vp(unit="cm/s")    "Velocity-proto";
Real Cfm(unit="-")      "Force coefficient-model";
Real Cfp(unit="-")      "Force coefficient-proto";
Real Fp(unit="N")       "Drag force-proto";

//===================================================

//Equation
equation
//Unit Conversion cm to m
Re_model=(rhom*(Vm/100)*(Lm/1000))/(mewm);
Re_proto=Re_model;
((rhop*(Vp/100)*(Lp/1000))/(mewp))=Re_proto;
Cfm=(Fm/(rhom*((Vm/100)^2)*((Lm/1000)^2)));
Cfp=Cfm;
Fp=(Cfp)*(rhop*((Vp/100)^2)*((Lp/1000)^2));

//===================================================
end Ex5_1;
//===================================================
