//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.1 page-348
//Topic     : Reynolds Number Regimes
//Caption   : Transition Reynolds number for flow in circular pipe

//===================================================
model Ex6_1

//Parameter
parameter Real Red_crit(unit="-") = 2300 "Transition reynolds number";
parameter Real d(unit="cm") = 5     "Diameter-pipe";

//Given: Fluid properties at 20deg.C
parameter Real rho_a(unit="kg/m^3") = 1.205     "Density-air";
parameter Real rho_w(unit="kg/m^3") = 998       "Density-water";
parameter Real mew_a(unit="kg/m.s") = 0.000018  "Viscosity-air";
parameter Real mew_w(unit="kg/m.s") = 0.001     "Viscosity-water";

//===================================================

//Variable

Real V_a(unit="m/s") "Velocity-air";
Real V_w(unit="m/s") "Velocity-water";

//===================================================

//Equation

equation

V_a=(Red_crit*mew_a)/(rho_a*(d/100));
V_w=(Red_crit*mew_w)/(rho_w*(d/100));

//===================================================
end Ex6_1;
//===================================================
