//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.10 page-376
//Topic     : Four Types of Pipe Flow Problems
//Caption   : Oil flows through a 30cm diameter pipe with volumetric flow rate given

//===================================================
model Ex6_10
extends ModelicaReference.Icons.Information;
extends Modelica.Math;

//Parameter

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant Real g(unit="m^2/s") = 9.81 "Standard acceleration of gravity on earth";

parameter Real Q(unit="m^3/s") = 0.342      "Flow rate";
parameter Real rho(unit="kg/m^3") = 950     "Density-oil";
parameter Real v(unit="m^2/s") = 0.00002    "Kinematic viscosity-oil";
parameter Real L(unit="m") = 100            "Length of pipe";
parameter Real hf(unit="m") = 8             "Head loss";
parameter Real e(unit="mm") = 0.06          "Roughness height";

//Guess value of f (Friction factor)
parameter Real f1(unit="-") = 0.03      "Friction factor-Guess1";
parameter Real f2(unit="-") = 0.0203    "Friction factor-Guess2";
parameter Real f3(unit="-") = 0.0201    "Friction factor-Guess3";

//===================================================

//Variable

Real d1(unit="m")       "Diameter of pipe for Guess1";
Real rey1(unit="-")     "Reynolds number for Guess1";
Real r_rough1(unit="-") "Ratio of roughness factor for Guess1";

Real d2(unit="m")       "Diameter of pipe for Guess2";
Real rey2(unit="-")     "Reynolds number for Guess2";
Real r_rough2(unit="-") "Ratio of roughness factor for Guess2";

Real d3(unit="m")       "Diameter of pipe for Guess3";
Real rey3(unit="-")     "Reynolds number for Guess3";
Real r_rough3(unit="-") "Ratio of roughness factor for Guess3";

//===================================================

//Equation

equation

//Simplified equations are given in the textbook:

//Guess1 : f = 0.03

d1=(0.655*(f1^0.2)); 
rey1=(4/pi)*(Q/(v*d1));
r_rough1=(e/1000)/(d1);

//Guess : f = 0.0203

d2=(0.655*(f2^0.2));
rey2=(4/pi)*(Q/(v*d2));
r_rough2=(e/1000)/(d2);

//Guess : f = 0.0201

d3=(0.655*(f3^0.2));
rey3=(4/pi)*(Q/(v*d3));
r_rough3=(e/1000)/(d3);

//===================================================
end Ex6_10;
//===================================================
