//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.14 page-386
//Topic     : Flow in Noncircular Ducts
//Caption   : Flow to reservoir through steel annulus

//===================================================
model Ex6_14
extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real Q(unit="m^3/s") = 0.01       "Flow rate";
parameter Real L(unit="m") = 30             "Length-annulus";
parameter Real rho(unit="kg/m^3") = 1000    "Density-water";
parameter Real v(unit="m^2/s") = 0.00000102 "Flow rate";

//DATA: figure E6.14
parameter Real a(unit="cm") = 5 "Outer diameter-annulus";
parameter Real b(unit="cm") = 3 "Inner diameter-annulus";

//DATA: Table 6.1
parameter Real e(unit="mm") = 0.046 "Roughness height";

//DATA: Table 6.3
//For (b/a=3/5)
parameter Real gamma(unit="-") = 0.67 "Ratio: b/a";

//DATA: Eq. 3.43c
parameter Real alpha2(unit="-") = 1.03 "Kinetic factor";

//===================================================

//Variable

Real V(unit="m/s")      "Velocity";
Real Dh(unit="m")       "Hydraulic diameter";
Real rey(unit="-")      "Reynolds number";
Real ratio(unit="-")    "Ratio: e/Dh";
Real f(unit="-")        "Friction factor";
Real h(unit="m")        "Height-reservoir";


Real Dh_eff(unit="mm")      "Effective hydraulic diameter";
Real rey_eff(unit="-")      "Reynolds number for Dh_eff";
Real ratio_eff(unit="-")    "Ratio: e/Dh for Dh_eff";
Real f_eff(unit="-")        "Friction factor for Dh_eff";

//===================================================

//Equation

equation

V = Q/(pi*(((a/100)^2)-((b/100)^2)));
Dh=2*((a/100)-(b/100)); //Conversion: cm to m
rey=(V*Dh)/v;
ratio=(e/1000)/Dh;
(f^(-0.5))=((-2)*log10((ratio/3.7)+(2.51/(rey*(f^0.5)))));

Dh_eff=(gamma*Dh*1000); //Conversion: mm to m
rey_eff=(V*(Dh_eff/1000))/v;
ratio_eff=(e/1000)/((Dh_eff/1000));
(f_eff^(-0.5))=((-2)*log10((ratio_eff/3.7)+(2.51/(rey_eff*(f^0.5)))));

h=(((V^2)/(2*g))*(alpha2+(f_eff*(L/Dh))));

//===================================================
end Ex6_14;
//===================================================
