//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.16 page-396
//Topic     : Minor or Local Losses in Pipe System
//Caption   : Water is pumped between two reservoirs

//===================================================
model Ex6_16
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
parameter Real rho(unit="slug/ft^3") = 1.94 "Density-water";
parameter Real v(unit="ft^2/s") = 0.000011  "Kinematic viscosity-water";
parameter Real Q(unit="ft^3/s") = 0.2       "Flow rate-water";
parameter Real L(unit="ft") = 400           "Length-pipe";
parameter Real d(unit="in") = 2             "Diameter-pipe";
parameter Real ratio(unit="-") = 0.001      "Roughness ratio";
parameter Real z1(unit="ft") = 20           "Height-point1";
parameter Real z2(unit="ft") = 120           "Height-point2";

//DATA: Moody chart
parameter Real f(unit="-") = 0.0216 "Friction factor";

//===================================================

//Variable

Real V(unit="ft/s") "Velocity";
Real rey(unit="-")  "Reynolds number";
Real hp(unit="ft")  "Pressure head";
Real P(unit="hp")   "Pump Power";

//===================================================

//Equation

equation

V=Q/((pi/4)*((d*0.0833)^2));
rey=(V*(d*0.0833)/(v));
//DATA: Sum of minor loss coefficients: SUM(K) = 12.3
hp=(z2)-(z1)+(((V^2)/(2*g))*((f*L/(d*0.0833))+(12.3)));
P=((rho*g*Q*hp)*(1/550)); //Conversion: 1hp = 550 ft.lbf/s

//===================================================
end Ex6_16;
//===================================================
