//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.2 page-464
//Topic     : Momentum Integral Estimates
//Caption   : low speed, small-scale air.

//===================================================
package Ex7_2

model Ex7_2_a

//Parameter
parameter Real U(unit="ft/s") = 1 "Velocity";
parameter Real L(unit="ft") = 1 "Length";
parameter Real x(unit="ft") = 1 "Distance";

//DATA: Table A.1
parameter Real meww(unit="ft^2/s") = 0.0000108 "Velocity";

//DATA: Table A.2
parameter Real mewa(unit="ft^2/s") = 0.000161 "Velocity";

//===================================================

//Variable

Real rey(unit="-") "Trailing edge Reynolds number - air";
Real s(unit="in") "Laminar thickness - air";

//===================================================

//Equation

equation

rey=(U*L)/mewa; // rey  < (10^6)  

//USING: Eq. 7.1a
(s/x)=(5/((rey)^0.5))*(1/0.0833); //CONVERSION: ft to in

//===================================================
end Ex7_2_a;
//===================================================

model Ex7_2_b
extends Ex7_2_a;

//===================================================

//Variable

Real reyw(unit="-") "Trailing edge Reynolds number - water";
Real sw(unit="in") "Laminar thickness - water";

//===================================================

//Equation

equation

reyw=(U*L)/meww;
(sw/x)=(5/((reyw)^0.5))*(1/0.0833);

//===================================================
end Ex7_2_b;
//===================================================
end Ex7_2;
//===================================================
