//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.4 page-475
//Topic     : The Flat-Plate Boundary Layer
//Caption   : A hydrofoil placed in a seawater.

//===================================================
package Ex7_4
extends Modelica.Math;

model Ex7_4_a

//Parameter
parameter Real L(unit="ft") = 1.2 "Length-foil";
parameter Real b(unit="ft") = 6 "Breadth-foil";
parameter Real U(unit="ft/s") = 40 "Velocity-sea water";
parameter Real e(unit="ft") = 0.0004 "Roughness height";
parameter Real rho(unit="slugs/ft^3") = 1.99 "Density-sea water";
parameter Real mew(unit="ft^2/s") = 0.000011 "Kinematic viscosity-sea water";
parameter Real reyT(unit="-") = 500000 "Transitional Reynolds number";

//Variable
Real reyL(unit="-") "Reynolds number";
Real s(unit="ft") "Thickness-boundary layer";

//Equation
equation
reyL=(U*L)/mew;

//Eq.7.42
(s/L)=(0.16/((reyL)^(1/7)));

end Ex7_4_a;

model Ex7_4_b
extends Ex7_4_a;

//Variable
Real CD(unit="-") "Drag coefficient-Turbulent smooth wall flow";
Real D(unit="lbf") "Drag-both sides of foil";

//Equation
equation
CD=(0.031)/((reyL)^(1/7));
D=(2*CD)*((0.5*rho*U*U))*b*L;

end Ex7_4_b;

model Ex7_4_c
extends Ex7_4_a;
extends Ex7_4_b;

//Variable
Real CDt(unit="-") "Drag coefficient-(reyT=500000)";
Real Dt(unit="lbf") "Drag coefficient-(reyT=500000)";

//Equation
equation
CDt=(0.00349)-(1440/(reyL));
Dt=(2*CDt)*(0.5*rho*U*U)*b*L;

end Ex7_4_c;



model Ex7_4_d
extends Ex7_4_a;
extends Ex7_4_b;
extends Ex7_4_c;

//Variable
Real ratio(unit="-") "Ratio: L/e";
Real CDd(unit="-") "Drag coefficient-fully rough regime";
Real Dd(unit="lbf") "Drag-fully rough regime";


//Equation
equation
ratio=(L/e);

//Eq. 7.48b
CDd=(1.89+(1.62*log10(ratio)))^(-2.5);

Dd=(2*CDd)*(0.5*rho*U*U)*b*L;

end Ex7_4_d;



end Ex7_4;
