//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.13 page-652
//Topic     : Compressible Duct Flow with Friction
//Caption   : Air enters a pipe of 1cm diameter

//===================================================
package Ex9_13
extends Modelica.Math;

model Ex9_13_a

//Parameter
parameter Real D(unit="cm") = 1     "Pipe diameter";
parameter Real L(unit="m") = 1.2    "Pipe length";
parameter Real p1(unit="kPa") = 220 "Inlet pressure";
parameter Real T1(unit="K") = 300   "Inlet temperature";
parameter Real f(unit="-") = 0.025  "Friction factor";
parameter Real p2(unit="kPa") = 140 "Exit pressure";
parameter Real R(unit="m^2/s^2.K") = 287 "Air rate constant";
parameter Real k(unit="-") = 1.4    "Constant";

//Variable
//USING: Eq. 9.73
Real fld(unit="-")      "Solving Eq. 9.73";
Real G(unit="kg/s.m^2") "Mass flow per area";
Real A(unit="m^2")      "Area of pipe";
Real m(unit="kg/s")     "Mass flow";
Real rho2(unit="kg/m^3") "Outlet density";
Real V2(unit="m/s")     "Outlet velocity";
Real Ma2(unit="-")      "Mach number-outlet";


//Equation
equation
fld=(f*L/(D/100))+(2*log(p1/p2));
(G^2)=(((p1*1000)^2)-((p2*1000)^2))/(R*T1*fld);
A=(3.14/4)*(D/100)^2;
m=(G*A);
rho2=(p2*1000)/(R*T1);
V2=(G/rho2);
Ma2=(V2)/sqrt(k*R*T1);

end Ex9_13_a;
//===================================================

model Ex9_13_b
extends Ex9_13_a;

//Variable
Real fLD1(unit="-")     "Adiabatic friction relation point1";
Real fLD2(unit="-")     "Adiabatic friction relation point2";
Real DeltafLD(unit="-") "Change in adiabatic friction";
Real pstar(unit="Pa")   "Stagnation pressure";
Real Ma1a(unit="-")     "Mach number point1 - adiabatic condition";
Real Ma2b(unit="-")     "Mach number point2 - adiabatic condition";
Real V1a(unit="m/s")    "Velocity of inlet at adiabatic condition";
Real Rho1(unit="kg/m^3") "Density for adiabatic condition";
Real Mdot(unit="kg/s")  "Mass flow adiabatic condition";


//Equation Ex9_13_b
equation
//USING: Eq. 9.66 and Eq. 9.67
fLD1=(1-Ma1a^2)/k/Ma1a^2+(k+1)/2/k*log((k+1)*Ma1a^2/(2+(k-1)*Ma1a^2));
fLD2=(1-Ma2b^2)/k/Ma2b^2+(k+1)/2/k*log((k+1)*Ma2b^2/(2+(k-1)*Ma2b^2));
DeltafLD=f*(L/(D/100));
fLD1=fLD2+DeltafLD;

//USING: Eq. 9.68a for both points
(p1*1000/pstar)=((k+1)/(2+(k-1)*Ma1a^2))^0.5/Ma1a;
(p2*1000/pstar)=((k+1)/(2+(k-1)*Ma2b^2))^0.5/Ma2b;
V1a=(Ma1a)*sqrt(k*R*T1);
Rho1=(p1*1000)/R/T1;
Mdot=Rho1*(3.14/4)*((D/100)^2)*V1a;

end Ex9_13_b;
//===================================================
end Ex9_13;
//===================================================
