//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.15 page-658
//Topic     : Frictionless Duct Flow with Heat Transfer
//Caption   : What happens to the inlet flow if heat addition is increased

//===================================================
model Ex9_15

extends Modelica.Math;

//Parameter
parameter Real k(unit="-") = 1.4        "Constant";
parameter Real T01(unit="K")= 303       "Inlet stagnation temperature";
parameter Real q(unit="kJ/kg")= 1400    "Heat addition";
parameter Real cp(unit="J/kg.K") = 1005 "Specific heat of air";
parameter Real p1(unit="kPa") = 150     "Inlet pressure";

parameter Real R(unit="m^2/s^2.K") = 287    "Air rate constant";

//Variable 
Real T0star(unit="K")   "Critical stagnation temperature";
Real T_ratio(unit="-")  "Temperature ratio = T01/T0star";
Real Ma1_new(unit="-")  "Mach number";

//Inlet parameters
Real T1(unit="K")       "Inlet temperature";
Real a1(unit="m/s")     "Inlet sound velocity";
Real V1(unit="m/s")     "Inlet air velocity";
Real rho1(unit="kg/m^3") "Inlet air density";
Real m(unit="kg/s.m^2") "Mass flow rate per unit area";

//Equation
equation
T0star=(T01)+(q*1000/cp);
T_ratio=(T01/T0star);

//USING: Eq. 9.78a
T_ratio*(1+k*Ma1_new^2)^2=(k+1)*(Ma1_new^2)*(2+(k-1)*Ma1_new^2);

T1=(T01)/(1+0.2*Ma1_new^2);
a1=sqrt(k*R*T1);
V1=(Ma1_new*a1);
rho1=(p1*1000/(R*T1));
m=(rho1*V1);

//===================================================
end Ex9_15;
//===================================================
