//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.17 page-668
//Topic     : Two-Dimensional Supersonic Flow
//Caption   : What happens to the inlet flow

//===================================================
model Ex9_17
extends Modelica.Math;

model Ex9_17_a

//GIVEN: Fig. E9.17
//Parameter 
parameter Real Ma(unit="-") = 2         "Mach number";
parameter Real p(unit="lbf/in^2") = 10  "abs. pressure";
parameter Real Theta(unit="Deg.") = 10  "Angle turn";
parameter Real k(unit="-") = 1.4        "Constant";

//DATA: From Fig. 9.99 and Table B.2
parameter Real Man2(unit="-") = 0.8031 "Normal mach number for downstream";

//Variable
Real Num(unit="-",start=10)          "Numerator";
Real Denom(unit="-",start=10)        "Denomintaor";
Real beta(unit="Deg.",start=30)      "Angle";


//Equation
equation
Num=2*(Ma^2*(sin(beta*3.14/180)^2)-1)/(tan(beta*3.14/180));
Denom=(Ma^2)*(k+cos(2*beta*3.14/180))+(2);
(Theta)=(180/3.14)*atan(Num/Denom);

end Ex9_17_a;
//===================================================

model Ex9_17_b
extends Ex9_17_a;

//Variable
Real Man1(unit="-") "Normal Mach number upstream";
Real Ma2(unit="-") "Mach number downstream";
Real P_ratio(unit="-") "pressure ratio: p2/p1";

//Equation
equation
Man1=Ma*sin(beta*3.14/180);
Ma2=Man2/sin((beta-Theta)*3.14/180);
P_ratio=(1+k*Man1^2)/(1+Man2^2*k);

end Ex9_17_b;
//===================================================

model Ex9_17_c
extends Ex9_17_b;
extends Ex9_17_a;

//Variable
Real p2(unit="lbf/in^2 abs.") "Downstream pressure";

//Equation
equation
p2=(p*P_ratio);

end Ex9_17_c;
//===================================================

model Ex9_17_d
extends Ex9_17_a;
extends Ex9_17_b;
extends Ex9_17_c;

//Variable
Real mew(unit="Deg.") "Wave angle";
Real BETA(unit="Deg.") "Mach angle";

//Equation
equation
//USING: Eq.9.88
(mew)=(180/3.14)*asin((1/Ma));
(BETA)=asin(sin(mew*3.14/180)+2.4*(tan(Theta*3.14/180))/(4*cos(mew*3.14/180)))*(180/3.14);

end Ex9_17_d;
//===================================================

model Ex9_17_e
extends Ex9_17_d;
extends Ex9_17_a;
extends Ex9_17_b;
extends Ex9_17_c;

//Variable
Real p_ratio(unit="-") "Pressure ratio";
Real p2_e(unit="lbf/in^2 abs.") "Pressure ratio";

//Equation
equation
p_ratio=1+(k*Ma*Ma*tan(Theta*3.14/180))/sqrt(Ma*Ma-1);
p2_e=(p_ratio)*p;

end Ex9_17_e;
//===================================================
end Ex9_17;
//===================================================
