//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.18 page-672
//Topic     : Prandtl-Meyer Expansion Waves
//Caption   : Air flows with inlet Mach number equal to 3

//===================================================
package Ex9_18
extends Modelica.Math;

model Ex9_18_a
//Parameter 
parameter Real Ma1(unit="-") = 3            "Mach number";
parameter Real p1(unit="kPa") = 200         "Inlet pressure";
parameter Real k(unit="-") = 1.4            "Constant";
parameter Real del_omega(unit="Deg.") = 20  "Turn angle";

//Variable
Real po(unit="kPa")         "Isentropic Stagnation pressure";
Real K(unit="-")            "Constant dependant on constant k, K=(k+1/k-1)";
Real omega1(unit="Deg.")    "Angle";
Real C(unit="-")            "Constant depend on the constant-k";
Real omega2(unit="Deg.")    "Angle after flow expansion";
Real Ma2(unit="-",start=2)  "Mach number at outlet";
Real p2(unit="kPa")         "Isentropic pressure at point-2";

//Equation
equation
po=p1*(1+0.2*Ma1*Ma1)^3.5;

//USING: Eq. 9.99
K=(k+1)/(k-1);
omega1=(180/3.14)*(((K^0.5)*atan(sqrt(((Ma1*Ma1)-1)/K)))-atan(sqrt((Ma1*Ma1)-1)));

C=sqrt((k+1)/(k-1));
omega2=(omega1)+(del_omega);

omega2=(180/3.14)*(((K^0.5)*atan(sqrt(((Ma2*Ma2)-1)/K)))-atan(sqrt((Ma2*Ma2)-1)));

p2=(po)/(1+0.2*Ma2*Ma2)^3.5;

end Ex9_18_a;
//===================================================

model Ex9_18_b
extends Ex9_18_a;

//Variable
Real omega2b(unit="Deg.")   "Lower Prandtl-Meyer angle";
Real Ma2b(unit="-",start=2) "Mach number at outlet";
Real p2b(unit="kPa")        "Isentropic pressure at point-2";

//Equation
equation
omega2b=(omega1)-del_omega;

omega2b=(180/3.14)*(((K^0.5)*atan(sqrt(((Ma2b*Ma2b)-1)/K)))-atan(sqrt((Ma2b*Ma2b)-1)));

p2b=(po)/(1+0.2*Ma2b*Ma2b)^3.5;
end Ex9_18_b;
//===================================================
end Ex9_18;
//===================================================
