//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.2 page-616
//Topic     : The Speed of Sound
//Caption   : Estimate the speed of sound of carbon monoxide

//===================================================
model Ex9_2

//Parameter
parameter Real p(unit="kPa") = 200 "Pressure exerted by CO";

//DATA: Table: A.4
parameter Real Mw(unit="g/mol") = 28.01 "Molecular weight of CO";
parameter Real k(unit="-") = 1.40       "Specific heat ratio";
parameter Real T(unit="deg.C") = 300    "Temperature";

//===================================================

//Variable

Real aCO(unit="m/s")        "Speed of sound of CO";
Real RCO(unit="m^2/s^2.K")  "Rate constant of CO";

//===================================================

//Equation

equation

//USING: Eq. 9.3
RCO=(8314/Mw); //Rate constant R=8314 J/kmol.K
//USING: Eq. 9.16
aCO=(k*(RCO*(T+273)))^0.5;

//===================================================
end Ex9_2;
//===================================================
