//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.4 page-626
//Topic     : Insentropic Flow with Area Changes
//Caption   : Argon flows isentropically through a duct

//===================================================
package Ex9_4

model Ex9_4_a

//GIVEN: Fig. E9.4
//Parameter
parameter Real A1(unit="m^2") = 0.05        "Area of section-1";
parameter Real A2(unit="m^2") = 0.036       "Area of section-2";
parameter Real V1(unit="m/s") = 180         "Velocity at section-1";
parameter Real p1(unit="kPa") = 500         "Pressure at section-1";
parameter Real T1(unit="K") = 470           "Temperature at section-1";
parameter Real k(unit="-") = 1.4            "Specific heat ratio";
parameter Real cp(unit="m^2/s^2.K") = 1005  "Specific heat";

//GIVEN: for air
parameter Real R(unit="m^2/s^2.K") = 287 "Rate constant air";

//GIVEN:Super sonic condition 
//DATA: Table: B.1
parameter Real Maf(unit="-") = 1.4 "Mach number supersonic";

//Variable
Real To(unit="K") "isentropic stagnation temperature";

//Equation
equation
To=T1+(V1*V1/(2*cp));

end Ex9_4_a;

//===================================================

model Ex9_4_b
extends Ex9_4_a;

//Variable
Real a1(unit="m/s") "Local sound speed";
Real Ma1(unit="-") "Mach number section-1";

//Equation
equation
a1=(k*R*T1)^0.5;
Ma1=(V1/a1);

end Ex9_4_b; 
//===================================================

model Ex9_4_c
extends Ex9_4_a;
extends Ex9_4_b;

//Variable
Real po(unit="kPa") "isentropic stagnation pressure";

//Equation
equation
//USING: Eq. 9.34
po=p1*(1+(0.2*Ma1*Ma1))^3.5;

end Ex9_4_c; 
//===================================================

model Ex9_4_d
extends Ex9_4_a;
extends Ex9_4_b;
extends Ex9_4_c;

//Variable
Real A_reff(unit="m^2") "Critical sonic throat area";
Real m(unit="kg/s") "mass flow rate";

//Equation
equation
//USING: Eq. 9.45
((A1/A_reff)*(1.728*Ma1))=((1+(0.2*Ma1*Ma1))^3);
//USING: Eq. 9.46
(m*((R*To)^0.5))=(0.6847*(po*1000*A_reff));

end Ex9_4_d;
//===================================================

model Ex9_4_e
extends Ex9_4_a;
extends Ex9_4_b;
extends Ex9_4_c;
extends Ex9_4_d;

//Variable
Real Ma2(unit="-") "Mach number-section2";
Real p2(unit="kPa") "Pressure at section-2";

//Equation
equation
//CONDITION: Subsonic 
(A2/A_reff)=(1+(0.2*Ma2*Ma2))^3/1.2^3/Ma2;
p2=(po/(((1+((0.2*Ma2*Ma2)))^3.5)));

end Ex9_4_e;
//===================================================

model Ex9_4_f
extends Ex9_4_a;
extends Ex9_4_b;
extends Ex9_4_c;
extends Ex9_4_d;
extends Ex9_4_e;

//Variable
Real p2f(unit="kPa") "Pressure at section-2 at supersonic condition";

//Equation
equation
p2f=po/((1+(0.2*Maf*Maf))^3.5);

end Ex9_4_f;
//===================================================
end Ex9_4;
//===================================================
