//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.5 page-628
//Topic     : Isentropic Flow with Area Changes
//Caption   : Air expands through a throat to an exit

//===================================================
package Ex9_5
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
model Ex9_5_a

//Parameter 
parameter Real po(unit="kPa")= 200 "Initial Pressure";
parameter Real To(unit="K")= 500 "Initial Temperature";
parameter Real Ma(unit="-")= 2.5 "Mach Number";
parameter Real m(unit="kg/s")= 3 "Mass flow rate";
parameter Real k(unit="-")= 1.4 "Constant";

//GIVEN: Data
parameter Real R(unit="m^2/s^2.K") = 287 "Air rate constant";


//Variable
Real Af(unit="m^2") "Throat area";
Real D_throat(unit="cm") "Throat diameter";

//Equation
equation
//USING: Eq. 9.47
Af=(((R*To)^0.5)*(m))/(0.6847*po*1000);
(0.25*pi*D_throat*D_throat)=Af*100*100;
//CONVERSION: m to cm


end Ex9_5_a;
//===================================================

model Ex9_5_b
extends Ex9_5_a;

//Variable Ex9_5_b
Real pe(unit="Pa") "Exit pressure";


//Equation Ex9_5_b
equation
pe=(po*1000)/(1+0.2*(Ma*Ma))^3.5;

end Ex9_5_b;
//===================================================

model Ex9_5_c
extends Ex9_5_a;
extends Ex9_5_b;

//Variable Ex9_5_c
Real Te(unit="K") "Exit temperature";

//Equation Ex9_5_c
equation
Te=(To)/(1+0.2*(Ma*Ma));

end Ex9_5_c;
//===================================================

model Ex9_5_d
extends Ex9_5_a;
extends Ex9_5_b;
extends Ex9_5_c;

//Variable Ex9_5_d
Real Ve(unit="m/s") "Exit velocity";


//Equation Ex9_5_d
equation
Ve=(Ma)*(k*R*Te)^0.5;

end Ex9_5_d;
//===================================================

model Ex9_5_e
extends Ex9_5_a;
extends Ex9_5_b;
extends Ex9_5_c;
extends Ex9_5_d;

//Variable Ex9_5_e
Real ratio(unit="-") "Ae/Af(exit Area/throat Area)";
Real De(unit="cm") "Exit diameter";
Real Ae(unit="m^2") "Exit area";

//Equation Ex9_5_e
equation
ratio=((1+(0.2*(Ma*Ma)))^3)/(1.728*Ma);
Ae=(ratio*Af);
(0.25*pi*De*De)=Ae*10000;

end Ex9_5_e;
//===================================================
end Ex9_5;
//===================================================
