//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 10 : Open ChannelFlow
//Example    : 10.3 page-711
//Topic      : Uniform flow; The Chezy Formula
//Caption    : The asphalt-lined trapezoidal channel

//===================================================
model Ex10_3

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter
//GIVEN: Fig. E10.3
parameter Real Q(unit="ft^3/s") = 300 "Volumetric flow rate";
parameter Real S(unit="-") = 0.0015 "Slope of channel";
parameter Real B(unit="ft") = 6 "Base length";
parameter Real angle(unit="deg.") = 50 "Angle";


//DATA: Table 10.1 for asphalt
parameter Real n(unit="-") = 0.016 "Roughness factor";
parameter Real alpha(unit="-") = 1.49 "Conversion factor";

//===================================================

//Variable

Real yn(unit="ft") "Normal depth Function (Area and Hydraulic radius)";

//===================================================

//Equation

equation

//VALUES: Substitute the values in the equation;
//cot(50deg.) = 0.839
//Cosec(50deg.) = 1.3

Q=(alpha*(S^0.5)/n)*((B*yn)+(yn*yn*0.839))*((((B*yn)+(yn*yn*0.839))/(B+(2*yn*1.3)))^0.667);

//===================================================
end Ex10_3;
//===================================================
