//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.1 page-766
//Topic      : The Centifugal Pump
//Caption    : Given data of commercial centrigugal pump

//===================================================
package Ex11_1

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex11_1_a

//GIVEN: Fig. E11.1a
//Parameter
parameter Real r1(unit="in") = 4        "Inner radius";
parameter Real r2(unit="in") = 7        "Outer radius";
parameter Real beta1(unit="deg.") = 30  "Inner blade angle";
parameter Real beta2(unit="deg.") = 20  "Outer blade angle";
parameter Real r(unit="r/min") = 1440   "Rotational speed";
parameter Real alpha1(unit="deg.") = 90 "Velocity angle"; //From Fig. E11.1a
parameter Real b1(unit="in") = 1.75     "Blade width inlet";
parameter Real b2(unit="in") = 1.75     "Blade width outlet";
parameter Real rho(unit="slugs/ft^3") = 1.94 "Density of water";


//Variable
Real w(unit="rad/s")    "Angular velocity";
Real u1(unit="ft/s")    "Tip speed point-1";
Real u2(unit="ft/s")    "Tip speed point-2";
Real Vn1(unit="ft/s")   "Radial velocity point-1";
Real Q(unit="gal/min")  "Discharge";


//Equation
equation
w=(2*pi*r)/60; //CONVERSION: min to s
//CONVERSION: in to ft
u1=w*(r1*0.0833);
u2=w*(r2*0.0833);
Vn1=(u1*tan(beta1*pi/180));
Q=(2*pi*r1*0.0833*b1*0.0833*Vn1*60)*(1728/231);
//CONVERSION: ft^3/min to gal/ft^3

end Ex11_1_a;

//===================================================
model Ex11_1_b
extends Ex11_1_a;

//Variable
Real Vn2(unit="ft/s")       "Radial velocity point-2";
Real Vt2(unit="ft/s")       "Absolute circumferential velocity point-2";
Real alpha2(unit="deg.")    "Velocity angle point-2";
Real P(unit="hp")           "Water Power";

//Equation
equation
Vn2=(Q/60*231/1728)/((2*pi)*(r2*0.0833*b2*0.0833));
Vt2=u2-((Vn2)*(1/tan(beta2*pi/180)));
tan(alpha2)=(Vn2/Vt2);
//USING: Eq. 11.11
P*(550)=(rho*Q)*(u2*Vt2)*(1/60)*(231/1728);

end Ex11_1_b;

//===================================================
model Ex11_1_c

extends Ex11_1_b;
extends Ex11_1_a;

//Variable
Real H(unit="ft") "Head";

//Equation
equation
H=(P*550)/(rho*g*(Q/60)*(231/1728));


end Ex11_1_c;

//===================================================
end Ex11_1;
//===================================================
