//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 11 : Turbomachinery
//Example    : 11.9 page-801
//Topic      : Turbines
//Caption    : A pelton wheel and Francis turbine

//===================================================
package Ex11_9

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex11_9_a
//GIVEN : Fig. 11.27
//Parameter 
parameter Real P(unit="bhp") = 30000    "Horse power";
parameter Real h(unit="ft") = 1200      "Net head";
parameter Real Nsp(unit="-") = 4.5      "Power specific speed - Pelton wheel";
parameter Real NspF(unit="-") = 29 "Power specific speed - Francis wheel";

parameter Real phi(unit="-") = 0.47 "Peripheral velocity factor";
parameter Real Cp(unit="-") = 2.70  "Optimum power coefficient";

//DATA: Property of water at 60deg.F
parameter Real rho(unit="slugs/ft^3") = 1.94 "Density of water";

//Variable
Real n(unit="r/s")  "Impeller revolution";
Real D(unit="ft")   "Impeller Diameter";

//For two wheel configuration
Real n_wheel(unit="r/min")  "Impeller revolution-two wheel";
Real D_wheel(unit="ft")     "Impeller Diameter-two wheel";

//Equation
equation
(Nsp/60)=(n)*(P^0.5)/(h^1.25);

phi=(pi*D*n)/((2*g*(h))^0.5);
n_wheel=(n*60)*(2^0.5);
D_wheel=(D/(2^0.5));

end Ex11_9_a;
//===================================================

model Ex11_9_b
extends Ex11_9_a;

//FOR: Francis wheel
//GIVEN: Fig. 11.22d
//Variable
Real dF(unit="ft")  "Diameter of Francis wheel";
Real nF(unit="r/s") "Impeller revolution Francis wheel";
Real DF(unit="in")  "Diameter of Francis wheel";

//Equation
equation

(NspF/60)=(nF*(P^0.5))/(h^1.25);

(Cp)=(P*550)/(rho*((nF)^3)*(dF^5));
DF=(dF/0.0833);

end Ex11_9_b;
//=================================================== 
end Ex11_9;
//===================================================
