//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.10 page-90
//Topic     : Hydrostatic Forces in Layered Fluids
//Caption   : A tank layered with oil

//===================================================
package Ex2_10

model Ex2_10_a

//Parameter
parameter Real rho(unit="lbf/ft^3") = 62.4 "Density of water";
parameter Real rho1(unit="lbf/ft^3") = 55 "Density of oil";
parameter Real rho2(unit="lbf/ft^3") = 846 "Density of mercury";
parameter Real l1(unit="ft") = 8  "Height of oil-layer";
parameter Real l2(unit="ft") = 6  "Height of water-layer";
parameter Real l3(unit="ft") = 4  "Height of mercury-layer";
parameter Real w(unit="ft") = 7   "Tank width";
parameter Real d(unit="ft") = 20  "Tank depth";

//Variable
Real pCG1(unit="lbf/ft^2") "Hydrostatic pressure at centroid-1"; 
Real pCG2(unit="lbf/ft^2") "Hydrostatic pressure at centroid-2";
Real pCG3(unit="lbf/ft^2") "Hydrostatic pressure at centroid-3";
Real F1(unit="lbf") "Force at portion-1";
Real F2(unit="lbf") "Force at portion-2";
Real F3(unit="lbf") "Force at portion-3";
Real F(unit="lbf")  "Net force";

//Equation
equation
pCG1=(rho1*l3);
pCG2=((rho1*l1)+(rho*((l2)/2)));
pCG3=((rho1*l1)+(rho*l2)+(rho2*(l3/2)));
F1=(pCG1*l1*w);
F2=(pCG2*l2*w);
F3=(pCG3*l3*w);
F=(F1+F2+F3);

end Ex2_10_a;
//===================================================
model Ex2_10_b
extends Ex2_10_a;
extends Modelica.Math;

//Variable
Real Ixx1(unit="ft^4") "Moment of inertia-1";
Real Ixx2(unit="ft^4") "Moment of inertia-2";
Real Ixx3(unit="ft^4") "Moment of inertia-3";
Real yCP1(unit="ft")  "Centre of pressure-1 (along y-axis)";
Real yCP2(unit="ft")  "Centre of pressure-2 (along y-axis)";
Real yCP3(unit="ft")  "Centre of pressure-3 (along y-axis)";
Real zCP1(unit="ft")  "Centre of pressure-1 (along z-axis)";
Real zCP2(unit="ft")  "Centre of pressure-2 (along z-axis)";
Real zCP3(unit="ft")  "Centre of pressure-3 (along z-axis)";
Real zCP(unit="ft")   "Centre of pressure (along z-axis)";


//Equation
equation
Ixx1=(w*((l1)^3))/12;
Ixx2=(w*((l2)^3))/12;
Ixx3=(w*((l3)^3))/12;
yCP1=(-rho1*Ixx1)/F1;
yCP2=(-rho*Ixx2)/F2;
yCP3=(-rho2*Ixx3)/F3;
zCP1=(-4+yCP1);
zCP2=(-11+yCP2);
zCP3=(-16+yCP3);
zCP=(((F1*zCP1)+(F2*zCP2)+(F3*zCP3))/F); //SUM(Fi*zCPi)=F*zCP

end Ex2_10_b;
//===================================================
end Ex2_10;
//===================================================
