//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.14 page-101
//Topic     : Hydrostatic Forces on Plane surfaces
//Caption   : U-Tube containing mercury.

//===================================================
model Ex2_15

//Parameter
parameter Real r(unit="in") = 10 "Radius";
parameter Real h(unit="in") = 30 "Height of mercury";
parameter Real sig(unit="r/min") = 180 "Angular velocity";
parameter Real pB(unit="lbf/ft^2") = 2116 "Atmospheric Pressure";
parameter Real lam(unit="lbf/ft^3") = 846 "Specific weight of mercury";
parameter Real g(unit="m/s^2") = 9.81 "Gravitational acceleration";



//Variable
Real rho(unit="slugs/ft^3") "Density of mercury";
Real C(unit="lbf/ft^2") "Constant";
Real pA(unit="lbf/ft^2") "Pressure at A";
Real H(unit="ft") "Actual drop in height";
Real pA1(unit="lbf/ft^2") "Pressure when tube at rest";
Real sig1(unit="rad/s") "Angular velocity";


//Equation
equation
sig1=(sig)*(2*3.14)/60;
rho =(lam/32.2);
C=((pB)-(0.5*rho*((r/(12))^(2))*(sig1^2)));
pA =(C-(lam*(-h/12)));
H=(((sig1)^2)*((r/12)^2)/(2*g*3.28));
pA1=(pB-(lam*(-(30/12))));

//===================================================
end Ex2_15;
//===================================================
