//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 2 : Pressure Distribution in a Fluid
//Example   : 2.7 page-85
//Topic     : Hydrostatic Forces on plane surfaces

//===================================================
package Ex2_7

model Ex2_7_a

//Parameter
parameter Real base(unit="m") = 6       "Base of Triangle";
parameter Real height(unit="m") = 12    "Height of Triangle";
parameter Real hCG(unit="m") = 9        "Depth of centroid";
parameter Real rho(unit="kg/m^3") = 800 "Density of oil";
parameter Real g(unit="m/s^2") = 9.81   "Acceleration-Gravity";

//Variable
Real Area(unit="m^2") "Area of triangle";
Real Ixx(unit="m^4")  "Moment of Inertia-xx";
Real Ixy(unit="m^4")  "Moment of Inertia-xy";
Real F(unit="N")     "Hydrostatic force";

//Equation
equation
Area = (0.5*base*height);   //Area of traingle
Ixx=((base*(height^3))/36); //Inertia-xx
Ixy=(-base*base*(height^2))/72; //Inertia-xy
F=(rho*g*hCG*Area); //Hydrostatic force

end Ex2_7_a;

//===================================================
model Ex2_7_b

extends Ex2_7_a;
extends Modelica.Math;

//Variable
Real yCP(unit="m") "Y-Component of point-CP";
Real xCP(unit="m") "X-Component of point-CP";

//Equation
equation
yCP=-(Ixx*sin(30*(3.14/180)))/(hCG*Area); //y-coordiante
xCP=-(Ixy*sin(30*(3.14/180)))/(hCG*Area); //x-Coordinate

end Ex2_7_b;

//===================================================
end Ex2_7;
//===================================================
