//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.1 page-148
//Topic     : The Reynolds Transport Theorem 
//Caption   : Fixed control volume with three dimensional boundary section.

//===================================================
model Ex3_1

//Parameter
parameter Real rhoi1(unit="kg/m^3") = 800 "Inlet-1 density";
parameter Real rhoi2(unit="kg/m^3") = 800 "Inlet-2 density";
parameter Real Vi1(unit="m/s") = 5 "Inlet-1 Velocity";
parameter Real Vi2(unit="m/s") = 8 "Inlet-2 Velocity";
parameter Real Ai1(unit="m^2") = 2 "Inlet-1 Area";
parameter Real Ai2(unit="m^2") = 3 "Inlet-2 Area";
parameter Real ei1(unit="J/kg") = 300 "Inlet-1 Energy";
parameter Real ei2(unit="J/kg") = 100 "Inlet-2 Energy";
parameter Real rho_o(unit="kg/m^3") = 800 "Outlet density";
parameter Real V_o(unit="m/s") = 17 "Outlet Velocity";
parameter Real A_o(unit="m^2") = 2 "Outlet Area";
parameter Real e_o(unit="J/kg") = 150 "Outlet Energy";

//Variable
Real E_rate(unit="MJ/s") "Rate of energy of system";
Real m_rate(unit="kg/s") "Rate of change of mass of system";

//Equation
equation
E_rate=(((-ei1*rhoi1*Ai1*Vi1)+(-ei2*rhoi2*Ai2*Vi2)+(rho_o*e_o*A_o*V_o))/(10^6)); //Energy of system

m_rate=((-rhoi1*Ai1*Vi1)+(-rhoi2*Ai2*Vi2)+(rho_o*V_o*A_o)); //Mass conservation

//===================================================
end Ex3_1;
//===================================================
