//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.20 page-186
//Topic     : The Energy Equation 
//Caption   : A steady flow machine takes in air.

//===================================================
model Ex3_20

//Parameter

parameter Real g(unit="ft/s^2") = 32.2 "Gravity-acceleration";
parameter Real A1(unit="ft^2") = 0.4 "Area section-1";
parameter Real A2(unit="ft^2") = 1.0 "Area section-2";
parameter Real A3(unit="ft^2") = 0.25 "Area section-3";

parameter Real Q1(unit="ft^3/s") = 100 "Volumetric flow rate-air section-1";
parameter Real Q2(unit="ft^3/s") = 40 "Volumetric flow rate-air section-2";
parameter Real Q3(unit="ft^3/s") = 50 "Volumetric flow rate-air section-3";

parameter Real T1(unit="Deg.F") = 70 "Temeperature section-1";
parameter Real T2(unit="Deg.F") = 100 "Temeperature section-2";
parameter Real T3(unit="Deg.F") = 200 "Temeperature section-3";

parameter Real p1(unit="lbf/in^2") = 20 "abs.Pressure section-1";
parameter Real p2(unit="lbf/in^2") = 30 "abs.Pressure section-2";

parameter Real z1(unit="ft") = 1.0 "Length section-1";
parameter Real z2(unit="ft") = 4.0 "Length section-2";
parameter Real z3(unit="ft") = 1.5 "Length section-3";

parameter Real r(unit="hp") = 150 "Rate of work to machine";
parameter Real cp(unit="ft.lbf/(slug.Deg.R)") = 6003 "Specific heat";
parameter Real R(unit="ft.lbf/(slug.Deg.R)") = 1716 "Perfect gas-constant";
parameter Real c(unit="ft.lbf/(s.hp)") = 550 "Rotation_torque";

//Variable
Real V1(unit="ft/s") "Velocity section-1";
Real V2(unit="ft/s") "Velocity section-2";
Real V3(unit="ft/s") "Velocity section-3";

Real rho1(unit="slug/ft^3") "Density of fluid section-1";
Real rho2(unit="slug/ft^3") "Density of fluid section-2";
Real rho3(unit="slug/ft^3") "Density of fluid section-3";

Real m1(unit="slug/s") "Mass flow rate section-1";
Real m2(unit="slug/s") "Mass flow rate section-2";
Real m3(unit="slug/s") "Mass flow rate section-3";


Real p3(unit="lbf/in^2") "Pressure section-3";
Real Ws(unit="lbf.ft/s") "Work by shaft";
Real En_flux(unit="ft.lbf/s") "Ethalpy flux";
Real KE_flux(unit="ft.lbf/s") "Kinetic energy flux";
Real PE_flux(unit="ft.lbf/s") "Potential energy flux";
Real Q(unit="Btu/s") "Heat transfer";

//Equation
equation
V1=(Q1/A1);
V2=(Q2/A2);
V3=(Q3/A3);

rho1 = ((p1*144)/(R*(T1+460))); //Unit Conversion : lbf/in^2 to lbf/ft^2 // Unit Conversion: Deg.F to Deg.R

rho2 = ((p2*144)/(R*(T2+460))); //Unit Conversion : lbf/in^2 to lbf/ft^2 // Unit Conversion: Deg.F to Deg.R

m1=(rho1*Q1);
m2=(rho2*Q2);

((rho3*Q3)+(rho2*Q2))=(rho1*Q1);
m3=(rho3*Q3);

p3=((rho3*R*(T3+460))/144); // Unit Conversion: Deg.F to Deg.R
//Unit Conversion : ft^2 to in^2

//(1 hp = (550 ft.lbf/s) = c)
Ws=(r*c); //Shaft work negative on control volume

En_flux=((cp)*((-m1*T1)+(m2*T2)+(m3*T3)));
KE_flux=((0.5)*((-m1*V1^2)+(m2*V2^2)+(m3*V3^2)));
PE_flux=((g)*((-m1*z1)+(m2*z2)+(m3*z3)));

Q=(((En_flux+(KE_flux)+(PE_flux))-(Ws))/778.2);

//===================================================
end Ex3_20;
//===================================================

//Answer Variation: Greater than 2% of book value
//Variable  Obtained    TextBook_Value
//PE_flux   19.5738     20
