//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.24 page-193
//Topic     : the Energy Equation 
//Caption   : Pump delivers water to a machine.

//===================================================
model Ex3_24
extends Modelica.Math;

//Parameter
parameter Real Q(unit="ft^3/s") = 1.5       "Volumetric flow rate";
parameter Real gamma(unit="lbf/ft^3") = 62.4 "Specific weight-water";
parameter Real z2(unit="ft") = 20 "Height of machine from reservoir surface";
parameter Real alpha(unit="-") = 1.07 "Kinetic energy factor correction";
parameter Real K(unit="-") = 7.5 "Loss coefficient";
parameter Real eff(unit="%") = 80 "Pump efficiency";


//Given: Figure E3.24
parameter Real D2(unit="in") = 3 "Diameter machine pipe";
parameter Real p2(unit="lbf/in^2") = 10 "Pressure-point2";
parameter Real p1(unit="lbf/in^2") = 14.7 "abs.Pressure-point1";

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant Real g(unit="ft/s^2") = 32.2 "Gravity-acceleration";

//===================================================

//Variable
Real V2(unit="ft/s")    "Velocity-exit";
Real A2(unit="ft^2")    "Area-section2";
Real hp(unit="ft")      "Pump head";
Real P_pump(unit="hp")  "Pump power";
Real P_input(unit="hp") "Pump power-input";
Real P1(unit="lbf/ft^2")"abs.Pressure-point1";
Real P2(unit="lbf/ft^2")"Pressure-point2";

//===================================================

//Equation
equation
P1=(p1*144);
P2=(p2*144);
A2=(pi/4)*((D2/12)^2);
V2=(Q/(A2));
hp=(((P2-P1)/gamma)+(z2)+((alpha+K)*((V2^2)/(2*g))));
P_pump=(gamma*Q*hp)/550; //Conversion of ft.lbf/s to hp
// 1hp = 500 lbf.ft/s

P_input=(P_pump/(eff/100));

//===================================================
end Ex3_24;
//===================================================
