//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 3 : Integral Relations for a Control Volume
//Example   : 3.5 page-154
//Topic     : Conservation of Mass 
//Caption   : Tank is filled with water by two dimensional inlets.

//===================================================
model Ex3_5

//Parameter
parameter Real D1(unit="in") = 1    "Diameter inlet-1";
parameter Real D2(unit="in") = 3    "Diameter inlet-2";
parameter Real V1(unit="ft/s") = 3  "Velocity at inlet-1";
parameter Real V2(unit="ft/s") = 2  "Velocity at inlet-2";
parameter Real At(unit="ft^2") = 2  "Area of tank";

//Variable
Real h_rate(unit="ft/s") "Change of water height";
Real Q1(unit="ft^3/s") "Flow rate inlet-1";
Real Q2(unit="ft^3/s") "Flow rate inlet-2";
Real A1(unit="ft^2") "Area inlet-1";
Real A2(unit="ft^2") "Area inlet-2";


//Equation
equation
A1=((1/4)*(3.14)*(0.083333^2)); //in to ft conversion
A2=((1/4)*(3.14)*((3*0.083333)^2)); //in to ft conversion
Q1=(A1*V1);
Q2=(A2*V2);

h_rate=((Q1+Q2)/(At));

//===================================================
end Ex3_5;
//===================================================
