//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 5 : Dimensional Analysis and Similarity
//Example   : 5.8 page-320
//Topic     : Nondimensionalization of the Basic Equations
//Caption   : Telephone wire are said to sing in the wind.

//===================================================
model Ex5_8

//Parameter
parameter Real d(unit="mm") = 8 "Diameter-wire";

//Figure 5.2b
//Given data
parameter Real v(unit="m^2/s") = 0.000015   "Kinematic viscosity-air";
parameter Real f(unit="Hz") = 262           "Frequency middle-C";
parameter Real St1(unit="-") = 0.2          "Strouhal number";
parameter Real St2(unit="-") = 0.21         "Strouhal number";

//===================================================

//Variable
Real U_wind_St1(unit="m/s") "Velocity-wind"; //St=0.2
Real U_wind_St2(unit="m/s") "Velocity-wind"; //St=0.21
Real Red(unit="-")          "Reynolds number";

//===================================================

//Equation

equation

// Note: f = (w/2.pi)
U_wind_St1=(f*(d/1000))/St1;
U_wind_St2=(f*(d/1000))/St2;
Red=(U_wind_St1*(d/1000))/(v);

//===================================================
end Ex5_8;
//===================================================
