//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.13 page-383
//Topic     : Flow in Noncircular Ducts
//Caption   : Fuid flows between horizontal parallel plates

//===================================================
package Ex6_13
extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//GIVEN: Moody Chart Fig. 6.13

model Ex6_13_a

parameter Real V(unit="ft/s") = 6           "Average velocity-Fluid";
parameter Real H(unit="in") = 2.4           "Distance between plates";
parameter Real L(unit="ft") = 100           "Length-Plate";
parameter Real rho(unit="slug/ft^3") = 1.9  "Density-Fluid";
parameter Real v1(unit="ft^2/s") = 0.00002  "Kinematic viscosity-Fluid";
parameter Real v2(unit="ft^2/s") = 0.002    "Kinematic viscosity-Fluid";

//Given: Fig. 6.13 to get friction factor value (Moody chart)
parameter Real f1(unit="-") = 0.0173        "Friction factor";
parameter Real f1_eff(unit="-") = 0.0189    "Friction factor";

//===================================================

//Variable Es6_13_a

Real Dh(unit="ft")              "Spacing between plates";
Real rey1(unit="-")             "Reynolds number for v1";
Real hf1(unit="ft")             "Head loss for v1";
Real del_p1(unit="lbf/ft^2")    "Pressure drop for v1";

//For better accuracy taking D_eff = 64/96(DH)
Real rey1_eff(unit="-")             "Reynolds number for v1";
Real hf1_eff(unit="ft")             "Head loss for v1";
Real del_p1_eff(unit="lbf/ft^2")    "Pressure drop for v1";

//===================================================

//Equation

equation

Dh=(2*(H)*0.0833);
rey1=(V*Dh)/v1;
hf1 = (f1*L*(V^2))/(Dh*2*g);
del_p1=(rho*g*hf1);

rey1_eff=(64/96)*(rey1);
hf1_eff=(f1_eff)*(L*(V^2))/(Dh*2*g);
del_p1_eff=(rho*g*hf1_eff);

//===================================================
end Ex6_13_a;
//===================================================

model Ex6_13_b
extends Ex6_13_a;

//Variable Ex6_13_b

Real rey2(unit="-")             "Reynolds number for v2";
Real hf2(unit="ft")             "Head loss for v2";
Real del_p2(unit="lbf/ft^2")    "Pressure drop for v2";
Real f2(unit="-")               "Friction factor";

//Using Eq. 6.63
Real hf2_a(unit="ft")           "Head loss for v2 (Eq. 6.63)";
Real del_p2_a(unit="lbf/ft^2")  "Pressure drop for v2 Eq. 6.63";

//===================================================

//Equation Ex6_13_b

equation

rey2=(V*Dh)/v2;

//From Eq. 6.64
f2=(96/rey2);

hf2=(f2*L*(V^2))/(Dh*2*g);
del_p2=(rho*g*hf2);

//USING: Eq.6.63
V=(((Dh/4)^2)*(del_p2_a))/(3*(rho*v2)*L);
hf2_a=(del_p2_a)/(rho*g);

//===================================================
end Ex6_13_b;
//===================================================
end Ex6_13;
//===================================================
