//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.2 page-354
//Topic     : Internal versus External Viscous Flows
//Caption   : A half inch water pipe used to deliver water

//===================================================
model Ex6_2

//Parameter
parameter Real d(unit="in") = 0.5       "Diameter-pipe";
parameter Real L(unit="ft") = 60        "Length-pipe";
parameter Real Q(unit="gal/min") = 5    "Flow rate-water";

final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Data: Table- 1.4
parameter Real v(unit="ft^2/s") = 1.09e-5 "Kinematic viscosity-water";

//===================================================

//Variable

Real V(unit="ft/s")  "Average velocity";
Real rey(unit="-")   "Reynolds number";
Real ratio(unit="-") "Length/Diameter (L/d)";
Real ent(unit="-")   "Entrance length (Le/d)";
Real f(unit="%")     "Fraction-type of flow (Le/L)";

//===================================================

//Equation

equation

V=(Q*0.00223)/((pi/4)*((d/12)^2));
//Unit conversion in to ft
// gal/min to ft^3/s

rey=(V*(d/12))/v;
// Reynolds number > 4000, Applying equation 6.6

ent=(1.6*((rey^0.25)));
ratio=(L/(d/12));
f=(ent/ratio)*100;

//===================================================
end Ex6_2;
//===================================================

//Remarks

//Parameter     Textbook Value      Obtained Value
//Fraction(%)   1.5                 1.47741

//It's an round off value in textbook
