//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.21 page-427
//Topic     : Fluid Meters
//Caption   : Flow of water through a 200mm diameter pipe

//===================================================
package Ex6_21

extends Modelica.Math;
extends Modelica.Constants;


model Ex6_21_a

//Parameter
parameter Real rho(unit="kg/m^3") = 1000    "Density-Water";
parameter Real v(unit="m^2/s") = 0.00000102 "Kinematic viscosity-water";
parameter Real D(unit="mm") = 200           "Diameter-pipe";
parameter Real V1(unit="m/s") = 2.0         "Average velocity";
parameter Real pdiff(unit="Pa") = 50000     "Pressure difference";

//GUESS: Part(a)
parameter Real beta1(unit="") = 0.5     "Pressure ratio-Guess1";
parameter Real beta2(unit="") = 0.566   "Pressure ratio-Guess2";
parameter Real beta3(unit="") = 0.559   "Pressure ratio-Guess3";
//GIVEN: Discharge coefficient(Cd)=f(rey,beta)

//GUESS: Part(b)
parameter Real beta1_b(unit="") = 0.5   "Pressure ratio-Guess1-partb";
parameter Real beta2_b(unit="") = 0.442 "Pressure ratio-Guess2-partb";
parameter Real beta3_b(unit="") = 0.445 "Pressure ratio-Guess3-partb";
//GIVEN: Discharge coefficient(Cd)=f(rey,beta)

//GUESS: Part(c)
parameter Real beta1_c(unit="") = 0.5   "Pressure ratio-Guess1-partc";
parameter Real beta2_c(unit="") = 0.445 "Pressure ratio-Guess2-partc";
parameter Real beta3_c(unit="") = 0.447 "Pressure ratio-Guess3-partc";
//GIVEN: Discharge coefficient(Cd)=f(rey,beta)


//Variable
Real rey(unit="-")      "Reynolds number";
Real alpha1(unit="-")   "Flow coefficient-Guess1";
Real alpha2(unit="-")   "Flow coefficient-Guess1";
Real Cd1(unit="-")      "Discharge coefficient-Guess1";
Real Cd2(unit="-")      "Discharge coefficient-Guess2";
Real d(unit="mm")       "Orifice diameter";



//Equation
equation
rey=(V1*(D/1000))/v; //CONVERSION: mm to m

(beta1^2)=(0.2/alpha1);
(alpha1)=(Cd1/((1-(beta1^4))^0.5));

(V1/(beta2^2))=(alpha2)*((2*(pdiff)/rho)^0.5);
(alpha2)=(Cd2/((1-(beta2^4))^0.5));

d=(beta3*D);

//===================================================
end Ex6_21_a;
//===================================================

model Ex6_21_b
extends Ex6_21_a;

//Variable Ex6_21_b
Real alpha1_b(unit="-") "Flow coefficient-Guess1-partb";
Real alpha2_b(unit="-") "Flow coefficient-Guess1-partb";
Real Cd1_b(unit="-")    "Discharge coefficient-Guess1-partb";
Real Cd2_b(unit="-")    "Discharge coefficient-Guess2-partb";
Real d_b(unit="mm")     "Nozzle diameter";

//Equation Ex6_21_b
equation
(V1/(beta1_b^2))=(alpha1_b)*((2*(pdiff)/rho)^0.5);
(alpha1_b)=(Cd1_b/((1-(beta1_b^4))^0.5));

(V1/(beta2_b^2))=(alpha2_b)*((2*(pdiff)/rho)^0.5);
(alpha2_b)=(Cd2_b/((1-(beta2_b^4))^0.5));

d_b=(beta3_b*D);

//===================================================
end Ex6_21_b;
//===================================================

model Ex6_21_c
extends Ex6_21_a;
extends Ex6_21_b;

//Variable Ex6_21_b
Real alpha1_c(unit="-") "Flow coefficient-Guess1-partc";
Real alpha2_c(unit="-") "Flow coefficient-Guess1-partc";
Real Cd1_c(unit="-")    "Discharge coefficient-Guess1-partc";
Real Cd2_c(unit="-")    "Discharge coefficient-Guess2-partc";
Real d_c(unit="mm")     "Venturi diameter";

//Equation Ex6_21_b
equation
(V1/(beta1_c^2))=(alpha1_c)*((2*(pdiff)/rho)^0.5);

(alpha1_c)=(Cd1_c/((1-(beta1_c^4))^0.5));

(V1/(beta2_c^2))=(alpha2_c)*((2*(pdiff)/rho)^0.5);

(alpha2_c)=(Cd2_c/((1-(beta2_c^4))^0.5));

d_c=(beta3_c*D);

//===================================================
end Ex6_21_c;
//===================================================
end Ex6_21;
//===================================================
