//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.4 page-359
//Topic     : Turbulence Modeling
//Caption   : Liquid flow through tank and a capillary tube

//===================================================
model Ex6_4

//Parameter
parameter Real rho_g(unit="lbf/ft^3") = 58 "Specific weight-liquid";
parameter Real alpha2(unit="-") = 2 "Kinetic energy coefficent"; //From Eq. 3.76

final constant Real g(unit="ft/s^2") = 32.2 "Gravity-acceleration";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Given: Fig. E6.4
parameter Real L(unit="ft") = 1         "Length-tank";
parameter Real d(unit="ft") = 0.004     "Diameter-tank";
parameter Real Q(unit="ft^3/h") = 0.15  "Volumetric flow rate";
parameter Real z1(unit="ft") = 2        "Distance-section1";
parameter Real z2(unit="ft") = 0        "Distance-section2";

//===================================================

//Variable

Real rho(unit="slug/ft^3")  "Density-liquid";
Real V2(unit="ft/s")        "Velocity-section2";
Real hf(unit="ft")          "Head loss";
Real mew(unit="slug/ft.s")  "Viscosity-liquid";
Real rey(unit="-")          "Reynolds number";

//===================================================

//Equation

equation

rho=(rho_g/g);
V2=(Q/3600)/((pi/4)*(d^2));
hf=(z1-z2)-(alpha2*V2^2/(2*g));
mew=(hf*rho_g*d^2)/(32*V2*L);
rey=(rho*V2*d)/(mew);

//===================================================
end Ex6_4;
//===================================================
