//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 6 : Viscous Flow in Ducts
//Example   : 6.6 page-371
//Topic     : Turbulent pipe flow
//Caption   : Asphalted cast iron pipe carrying water

//===================================================
model Ex6_6

//Parameter 
//Given: Fig. 6.7
parameter Real d(unit="ft") = 0.5 "Diameter-iron pipe";
parameter Real L(unit="ft") = 200 "Length-iron pipe";
parameter Real V(unit="ft/s") = 6 "Mean velocity-water";

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";

//Data: Table A.3 for water
parameter Real rho(unit="slug/ft^3") = 1.94 "Density-water";
parameter Real mew(unit="slug/ft.s") = 0.0000209 "Density-water";

//Data: Table: 6.1
parameter Real e(unit="ft") = 0.0004 "ephsilon";

//Data: moody chart Fig. 6.13
parameter Real f(unit="-") = 0.02 "Friction-factor";

//===================================================

//Variable

Real rey(unit="-") "Reynolds number";
Real ratio(unit="-") "Ratio: e/d";
Real hf(unit="ft") "Head loss";
Real del_p(unit="lbf/ft^2") "Pressure drop";

//===================================================

//Equation

equation

rey=(rho*V*d)/(mew);
ratio=(e/d);
hf=(f*L*V*V)/(d*2*g);
del_p=(rho*g*hf);

//===================================================
end Ex6_6;
//===================================================
