//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.10 page-509
//Topic     : Experimental External FLow
//Caption   : Ex7_9 maximum thrust is applied.

//===================================================
model Ex7_10

extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter

parameter Real W(unit="lbf") = 75000 "Weight of airplane";
parameter Real A(unit="ft^2") = 2500 "Platform area";
parameter Real T(unit="lb") = 12000 "Thrust";
parameter Real CDi(unit="-") = 0.02 "Drag coefficient inifiniy";
parameter Real AR(unit="-") = 7 "Aspect ratio";

//DATA: Table A.6 for z=6000m
parameter Real rho(unit="slug/ft^3") = 0.00128 "Density of sea=level";

//Variable
Real CL(unit="",start=0.1) "Finite span lift";
Real V(unit="ft/s",start=500) "Velocity of plane";

//Equation
equation
T=((0.02)+((CL*CL)/(pi*AR)))*(0.5*rho*V*V*A);

W=0.5*rho*(V^2)*A*CL;

end Ex7_10;
