//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 7 : Flow Past Immersed Bodies
//Example   : 7.8 page-495
//Topic     : Experimental External Flows
//Caption   : A high speed car deploys

//===================================================
model Ex7_8

//Parameter 
parameter Real m(unit="kg") = 2000  "Mass of car";
parameter Real CDc(unit="-") = 0.3  "Drag coefficient";
parameter Real Ac(unit="m^2") = 1   "Area of car";
parameter Real dp(unit="m") = 2     "Mass of car";
parameter Real Vo(unit="m/s") = 100 "Initial velocity of parachute";
parameter Real rho(unit="kg/m^3") = 1.2 "Density of air";

//Time Data
parameter Real t1(unit="s") = 1     "Time-1";
parameter Real t2(unit="s") = 10    "Time-2";
parameter Real t3(unit="s") = 100   "Time-3";
parameter Real t4(unit="s") = 1000  "Time-4";

//DATA: Table 7.3
parameter Real CDp(unit="-") = 1.2 "Drag coefficient of parachute";

//===================================================
//Variable

Real alpha(unit="s^-1") "alpha=(K*Vo/m)";

//For t=1s
Real V1(unit="m/s") "Velocity of car at t=1s";
Real S1(unit="m")   "Distance of car at t=1s";

//For t=10s
Real V2(unit="m/s") "Velocity of car at t=10s";
Real S2(unit="m")   "Distance of car at t=10s";

//For t=100s
Real V3(unit="m/s") "Velocity of car at t=100s";
Real S3(unit="m")   "Distance of car at t=100s";

//For t=1000s
Real V4(unit="m/s") "Velocity of car at t=1000s";
Real S4(unit="m")   "Distance of car at t=1000s";

//===================================================
//Equation

equation

alpha=0.5*((CDc*Ac+(CDp*3.14*dp^2/4)))*(rho)*(Vo)/m;

//For t=1s
V1=(Vo)/(1+alpha*t1);
S1=(Vo/alpha)*log(1+alpha*t1);

//For t=10s
V2=(Vo)/(1+alpha*t2);
S2=(Vo/alpha)*log(1+alpha*t2);

//For t=100s
V3=(Vo)/(1+alpha*t3);
S3=(Vo/alpha)*log(1+alpha*t3);

//For t=1000s
V4=(Vo)/(1+alpha*t4);
S4=(Vo/alpha)*log(1+alpha*t4);

//===================================================
end Ex7_8;
//===================================================
