//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 8 : Potential Flow and Computational Fluid Dynamics
//Example   : 8.1 page-537
//Topic     : Elementary Plane Flow Solutions
//Caption   : The bottom of a river.

//===================================================
model Ex8_1

extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Parameter 

//GIVEN: Fig. E8.1
parameter Real zA(unit="m") = 2     "Height of point-A";
parameter Real y(unit="m") = 4      "Middle height of bump";
parameter Real h(unit="m") = 2      "Bump height";
parameter Real U(unit="m/s") = 2.5  "River Velocity";
parameter Real pB(unit="kPa") = 130 "Pressure at point-B";


//DATA: For water at 20deg.
parameter Real rho(unit="kg/m^3") = 998     "Density of water";
parameter Real gamma(unit="N/m^3") = 9790   "Specific weight of water";

//===================================================

//Variable

Real a(unit="m")    "Distance";
Real VA(unit="m/s") "Velocity at point-A";
Real pA(unit="Pa")  "Pressure at point-A";

//===================================================

//Equation

equation

//USING: Eq. 8.18 and Fig. 8.6
a=(y/pi);
(VA^2)=(U*U)*(1+(a*a/((pi*a/2)^2))+((2*a/(pi*a/2))*(cos(pi/2))));
((pA/gamma)+((VA^2)/(2*g))+(zA)) = ((pB*1000/gamma)+((U^2)/(2*g)));

//===================================================
end Ex8_1;
//===================================================
