//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 8 : Potential Flow and Computational Fluid Dynamics
//Example   : 8.3 page-551
//Topic     : Plane Flow Past Closed-Body Shapes
//Caption   : The experimental Flettner rotor sailboat.

//===================================================
model Ex8_3

extends Modelica.Math;

final constant Real g(unit="m/s^2") = 9.81 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

//Given: Fig. E8.3

//Parameter

parameter Real d(unit="ft") = 2.5       "Diameter of rotor";
parameter Real b(unit="ft") = 10        "Length of rotor";
parameter Real ro(unit="r/min") = 220   "Rotor speed";
parameter Real V(unit="kn") = 10        "Wind velocity";

//USING: Fig. 8.15
parameter Real CL(unit="-") = 2.5   "Life coefficient";
parameter Real CD(unit="-") = 0.7   "Drag coefficient";
parameter Real a(unit="ft") = 1.25  "Intake length";

//DATA: Table A.6
parameter Real rho(unit="slug/ft^3") = 0.00238 "Air density";

//===================================================

//Variable

Real ratio(unit="-")    "Velocity ratio";
Real L(unit="lbf")      "Rotor lift";
Real D(unit="lbf")      "Rotor drag";
Real F(unit="lbf")      "Thrust";

//===================================================

//Equation

equation

//CONVERSION: r/min to rad/s
//CONVERSION: kn to ft/s
ratio=(a*(ro*2*pi/60))/(V*1.688);
L=(CL)*(0.5*rho)*((V*1.688)^2)*(2*b*a);
D=(CD*0.5)*(rho)*((V*1.688)^2)*(2*b*a);
(F^2)=(L*L)+(D*D);

//===================================================
end Ex8_3;
//===================================================
