//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.1 page-613
//Topic     : Introduction: Review of Thermodynamics
//Caption   : Argon flows through a tube

//===================================================
package Ex9_1

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex9_1_a

//Parameter
parameter Real p1(unit="MPa") = 1.7     "Initial pressure";
parameter Real rho1(unit="kg/m^3") = 18 "Initial density";
parameter Real p2(unit="kPa") = 248     "Final pressure";
parameter Real T2(unit="K") = 400       "Final temperature";

//DATA: Table A.4
parameter Real R(unit="m^2/s^2.K") = 208 "Gas rate constant";
parameter Real k(unit="-") = 1.67      "Specific heat ratio (cp/cv)";


//Variable
Real cp(unit="m^2/s^2.K")    "Specific Heat";
Real T1(unit="K")            "Initial temeperature";

//Equation
equation
//USING: Eq.9.4
cp= k*R/(k-1);
//USING Eq.9.2
//Ideal-gas law
T1=(p1*10^6)/(rho1*R);

end Ex9_1_a;


//===================================================

model Ex9_1_b
extends Ex9_1_a;

//Variable
Real rho2(unit="kg/m^3") "Final density";

//Equation
equation
rho2=(p2*1000/(T2*R));

end Ex9_1_b;
//===================================================

model Ex9_1_c
extends Ex9_1_b;
extends Ex9_1_a;

//Variable
Real Enthalpy_change(unit="J/kg") "Enthalpy change";

//Equation
equation
//USING: Eq.9.5
Enthalpy_change=cp*(T2-T1);

end Ex9_1_c;
//===================================================

model Ex9_1_d
extends Ex9_1_a;
extends Ex9_1_c;
extends Ex9_1_b;

//Variable
Real Entropy_change(unit="m^2/s^2.K") "Entropy change";

//Equation
equation
//USING: Eq.9.5
Entropy_change=(cp*(log(T2/T1)))-(R*(log((p2*1000)/((p1)*10^6))));

end Ex9_1_d;

//===================================================
end Ex9_1;
//===================================================
