//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.12 page-649
//Topic     : Compressible Duct Flow with Friction 
//Caption   : Air enters a 3cm diameter duct

//===================================================
package Ex9_12
extends Modelica.Math;

model Ex9_12_a

//Paramter
parameter Real po1(unit="kPa") = 200    "Initial Pressure";
parameter Real To(unit="K") = 500       "Initial Temperature";
parameter Real V1(unit="m/s") = 100     "Velocity section-1";
parameter Real D(unit="cm") = 3         "Diameter of duct";

parameter Real f(unit="-") = 0.02   "Friction factor";
parameter Real k(unit="-") = 1.4    "Constant";
parameter Real R(unit="m^2/s^2.K") = 287 "Air rate constant";

//DATA: Given in question
parameter Real Lb(unit="m") = 15 "Duct length for part-b";
parameter Real Lc(unit="m") = 30 "Duct length for part-c";
parameter Real cp(unit="m^2/s^2.K") = 1005 "Specific heat of air";


//Variable
Real T1(unit="K")   "Temperature at section-1";
Real a1(unit="m/s") "Speed of sound";
Real Ma1(unit="-")  "Mach number section-1";
Real ratio(unit="-") "(f)(L*)/D";
Real L(unit="m")    "Maximum duct length";

//Equation
equation
T1=To-(0.5*V1*V1/cp);
a1=(k*R*T1)^0.5;
Ma1=(V1/a1);
ratio=((1-Ma1*Ma1)/(k*Ma1*Ma1))+((k+1)/2*k)*log10((Ma1*Ma1*(k+1))/(2+(k-1)*Ma1*Ma1));
L=(ratio*(D/100))/f;

end Ex9_12_a;
//===================================================

model Ex9_12_b
extends Ex9_12_a;

//Variable Ex9_12_b
Real rho01(unit="kg/m^3")   "Stagnation density";
Real rho1(unit="kg/m^3")    "Initial density";
Real m(unit="kg/s")         "Mass flow rate";


//Equation Ex9_12_b
equation
rho01=((po1*1000)/(R*To));
rho1=(rho01)/(1+0.2*Ma1*Ma1)^2.5;
m=(rho1*((3.14/4)*(D/100)^2)*V1);

end Ex9_12_b;
//===================================================

model Ex9_12_c
extends Ex9_12_a;
extends Ex9_12_b;

//Variable Ex9_12_c
Real ratio1(unit="-") "fL/D";
Real Mac(unit="-") "Mach number";

Real T1_new(unit="K")       "Temperature for part-c";
Real a1_new(unit="m/s")     "Sound speed for part-c";
Real V1_new(unit="m/s")     "Velocity of air for part-c";
Real rho1_new(unit="Kg/m^3") "Density of air for part-c";
Real m_new(unit="kg/s")     "Mass flow rate for part-c";


//Equation Ex9_12_c
equation
ratio1=Lc*f/(D/100);
ratio1=((1-Mac*Mac)/(k*Mac*Mac))+((k+1)/2*k)*log10((Mac*Mac*(k+1))/(2+(k-1)*Mac*Mac));

T1_new=(To)/(1+0.2*Mac*Mac);
a1_new=(k*R*T1_new)^0.5;
V1_new=(Mac*a1_new);
rho1_new=rho01/(1+0.2*Mac*Mac)^2.5;
m_new=rho1_new*((3.14/4)*(D/100)^2)*V1_new;

end Ex9_12_c;
//===================================================
end Ex9_12;
//===================================================

//Remarks

//Round-off value in the decimal caused the change in final answer of textbook

//Variable          Textbook Value      Obtained Value
//Maximum           16.5                17.1554
//duct length(m)
