//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.16 page-661
//Topic     : Two dimensional super sonic flow
//Caption   : An observer on the ground hear the sonic

//===================================================
model Ex9_16
extends Modelica.Math;

//Parameter
parameter Real a(unit="km") = 5 "Ariplane altitude";
parameter Real b(unit="km") = 9 "Ariplane moved distance";

//Variable
Real mew(unit="Deg.")   "Wave angle";
Real Ma(unit="-")       "Mach number";

//Equation
equation
(mew)=atan(a/b);

//USING: Eq. 9.79
Ma=(1/sin(mew));

//===================================================
end Ex9_16;
//===================================================
