//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.21 page-677
//Topic     : Prandtl-Meyer Expansion Waves
//Caption   : By analogy with example 19

//===================================================
package Ex9_21
extends Modelica.Math;

model Ex9_21_a

//GIVEN: Fig. E9.21

//Parameter
parameter Real C(unit="m") = 2      "Chord length";
parameter Real wi(unit="m") = 1     "Width of foil";
parameter Real th(unit="m") = 0.07  "Thickness of foil";
parameter Real alpha(unit="Deg.") = 8 "Angle";
parameter Real ha(unit="Deg.") = 2  "Half Angle";
parameter Real Ma(unit="-") = 2.5   "Mach number";
parameter Real A(unit="m^2") = 2    "Wing area";
parameter Real k(unit="-") = 1.4    "Constant";

//ASSUME
parameter Real p(unit="kPa") = 100  "Pressure air foil";

//DATA: From Fig E9.21
parameter Real p2(unit="kPa") = 186.4   "Air foil pressure at point-2";
parameter Real p3(unit="kPa") = 65.9    "Air foil pressure at point-3";
parameter Real p4(unit="kPa") = 146.9   "Air foil pressure at point-4";
parameter Real p5(unit="kPa") = 48.8    "Air foil pressure at point-5";

//Variable
Real F(unit="kN") "Normal force";
Real P(unit="kN") "Chordwise force";

Real L(unit="kN") "Lift force";
Real D(unit="kN") "Drag force";

Real Deno(unit="kN") "Denominator of Eq. 9.102";
Real CL(unit="-")   "Lift coefficient";
Real CD(unit="-")   "Drag Coefficient";

//Equation
equation
F=0.5*((p2-p3)+(p4-p5))*A;
P=0.5*((p3-p5)+(p2-p4))*wi*th;

L=(F*cos(alpha*3.14/180))-(P*sin(alpha*3.14/180));
D=(F*sin(alpha*3.14/180))+(P*(cos(alpha*3.14/180)));

//USING: Eq. 9.102
Deno=(0.5*k*p*Ma*Ma*A);
CL=(L/Deno);
CD=(D/Deno);
end Ex9_21_a;
//===================================================

model Ex9_21_b
extends Ex9_21_a;

//Variable
Real CLA(unit="-")  "Lift coefficient by Arckeret theory";
Real CDA(unit="-")  "Lift coefficient by Arckeret theory";
Real y(unit="-")    "Mean square slope";

//Equation
equation

//USING: Ackeret theory
CLA=4*(alpha*3.14/180)/sqrt(Ma*Ma-1);
//USING: Eq. 9.106
y=(tan(ha*3.14/180))^2;
//USING: Eq. 9.107
CDA=(4/sqrt(Ma*Ma-1))*((alpha*3.14/180)^2+0.5*(2*y));

end Ex9_21_b;
//=================================================== 
end Ex9_21;
//===================================================
