//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 9 : Compressible Flow
//Example   : 9.3 page-621
//Topic     : Adiabatic and Isentropic Steady Flow
//Caption   : Air flows adiabatically through a duct

//===================================================
package Ex9_3

extends Modelica.Math;

final constant Real g(unit="ft/s^2") = 32.2 "Acceleration-gravity";
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

model Ex9_3_a

//Parameter
parameter Real V1(unit="m/s") = 240 "Velocity at point-1";
parameter Real V2(unit="m/s") = 290 "Velocity at point-2";

parameter Real T1(unit="K") = 320   "Temperature at point-1";
parameter Real p1(unit="kPa") = 170 "Pressure at point-1";
parameter Real p2(unit="kPa") = 135 "Pressure at Downstream";

//DATA: Ideal gas parameters
parameter Real R(unit="m^2/s^2.K") = 287    "Temperature at point-1";
parameter Real k(unit="-") = 1.40           "Specific heat ratio";
parameter Real cp(unit="m^2/s^2.K") = 1005  "Specific heat";

 
//Variable
Real T01(unit="K") "isentropic stagnation temperature at point-1";

//Equation
equation
T01=T1+(V1*V1/(2*cp));

end Ex9_3_a;
 //===================================================

model Ex9_3_b
extends Ex9_3_a;

//Variable
Real Ma1(unit="-") "Mach number";

//Equation
equation
Ma1=((5*((T01/T1)-1)))^0.5;

end Ex9_3_b;
//===================================================

model Ex9_3_d
extends Ex9_3_b;
extends Ex9_3_a;

//Variable
Real p01(unit="kPa") "isentropic stagnation Pressure at point-1";

//Equation
equation
p01=p1*(1+(0.2*Ma1*Ma1))^3.5;

end Ex9_3_d;
//===================================================

model Ex9_3_c
extends Ex9_3_a;
extends Ex9_3_b;
extends Ex9_3_d;

//Variable
Real rho01(unit="kg/m^3") "isentropic stagnation density at point-1";

//Equation
equation
rho01=(p01/(R*T01))*(1000);

end Ex9_3_c;
//===================================================

model Ex9_3_e

extends Ex9_3_a;
extends Ex9_3_b;
extends Ex9_3_d;
extends Ex9_3_c;

//Variable
Real Vmax(unit="m/s") "Maximum velocity";

//Equation
equation
Vmax=(2*cp*T01)^0.5;

end Ex9_3_e;
//===================================================

model Ex9_3_f
extends Ex9_3_a;
extends Ex9_3_b;
extends Ex9_3_d;
extends Ex9_3_c;
extends Ex9_3_e;

//Variable
Real V_ref(unit="m/s") "Reference velocity";

//Equation
equation
V_ref=((2*k/(k+1))*(R*T01))^0.5;

end Ex9_3_f;
//===================================================

model Ex9_3_g
extends Ex9_3_a;
extends Ex9_3_b;
extends Ex9_3_d;
extends Ex9_3_c;
extends Ex9_3_e;
extends Ex9_3_f;

//Variable
Real T2(unit="K") "Downstream temperature";
Real p02(unit="kPa") "isentripic stagnation pressure at point 2";

//Equation
equation
//USING: Eq. 9.23
//DATA: T01=T02 (Stagnation temperature are constant at both the points)
T2=(T01)-(V2*V2/(2*cp));
p02=p2*((T01/T2)^(k/(k-1)));

end Ex9_3_g;
//===================================================
end Ex9_3;
//===================================================
