//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.1 page-12
//Topic     : Dimensions and Units
//Caption   : A body weighs 1000lbf

//===================================================
package Ex1_1

model Ex1_1_a

//Parameter section

parameter Real w(unit="lbf")=1000       "Body weight in lbf";
parameter Real g(unit="ft/s^2")=32.174  "Gravitational acceleration";
parameter Real gmoon(unit="m/s^2")=1.62 "Moon's acceleration";
parameter Real Nf(unit="lbf")=400       "Net force";

//Variable section

Real m(unit="kg")     "mass";

//Equation section

equation
m =((w/g)*14.5939);     //Mass in 'kg'

end Ex1_1_a;

//===================================================

model Ex1_1_b
extends Ex1_1_a;

//Variable section

Real Wmoon(unit="N")  "Weight on the moon";

//Equation section

equation
Wmoon=m*gmoon;      //Mass of the body remains same regardless of its location

end Ex1_1_b;

//===================================================

model Ex1_1_c
extends Ex1_1_b;

//Variable section

Real a(unit="m/s^2")  "Acceleration of body";

//Equation section

equation
a=(Nf/(w/g))*0.3048;//Acceleration for the applied force

end Ex1_1_c;

//===================================================

end Ex1_1;

//===================================================
