//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.2 page-12
//Topic     : Dimensions and Units
//Caption   : Industries involved in viscosity measurement

//===================================================
package Ex1_2

model Ex1_2_a

//Parameter section

parameter Real Mew(unit="poise")=0.01 "Viscosity of water @ 20 deg.Cel";
parameter Real v(unit="stokes")=0.01  "Kinematic Viscosity of water @ 20 deg.Cel";

//Variable section

Real Mew1(unit="kg/m.s")     "Viscosity in SI units";
Real v1(unit="m^2/s")        "Kinematic Viscosity in SI units";

//Equation section

equation
Mew1 = Mew/(1000*0.01); // SI units
v1 = v*(0.01*0.01); //SI units

end Ex1_2_a;

//===================================================

model Ex1_2_b
extends Ex1_2_a;

//Variable section

Real Mew2(unit="slug/ft.s")  "Viscosity in BG units";
Real v2(unit="ft^2/s")       "Kinematic viscosity in BG units";

//Equation section

equation
Mew2 = (Mew/(1000*14.5939*0.01))*(0.3048); //BG units
//Kinematic viscosity unit conversion
v2= ((v*0.01^2)/(0.3048^2)); //BG units

end Ex1_2_b;


//===================================================

end Ex1_2;

//===================================================
