//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.7 page-29
//Topic     : Dimensions and Units
//Viscosity and Other Secondary Properties

//Caption   : SAE 30 oil at 20 deg.C

//===================================================
model Ex1_7

//Parameter section
  
parameter Real V(unit="m/s")=3         "Velocity";
parameter Real h(unit="cm")=2          "height";

//DATA: Table 1.4 for SAE 30 oil
parameter Real mew(unit="kg/m.s")=0.29 "Viscosity of SAE30 oil";

//===================================================

//Variable section

Real tow(unit="Pa")     "Shear Stress"; 


//===================================================
//Equation section

equation
//USING: Eq. 1.26
tow = mew*(V/(h/100)); // h in 'cm' to 'm'

//===================================================
end Ex1_7;
//===================================================
