//Textbook  : Fluid Mechanics 
//Author    : Francis M. White
//Publisher : McGraw-Hill
//2011

//Chapter 1 : Intoduction
//Example   : 1.9 page-35
//Topic     : Dimensions and Units
//Caption   : A certain torpedo moving in fresh water

//===================================================
model Ex1_9

//Parameter section

parameter Real T(unit="Deg.Celcius")=10   "Water temperature";
parameter Real po(unit="kPa")=115         "Initial pressure";

//Data collected from Table A.1 for 10 deg.Celcius
parameter Real Rho(unit="kg/m^3")=1000 "Water density";

//DATA: Table A.5
parameter Real pv(unit="kPa")=1.227    "Vapor pressure";

//===================================================

//Variable section

Real V(unit="m/s")  "Characteristic flow velocity";


//===================================================

//Equation section
//GIVEN: equation(1) in question
equation

//GIVEN EQUATION : Minimum pressure point = Initial pressure - 0.35*water density*(characteristic velocity)^2

// pmin = po - 0.35*Rho*V^2

// Cavitation bubbles form when the minimum pressure equals the vapor pressure.
// pmin = pv

V = (((-pv*1000)+(po*1000))/(0.35*Rho))^(0.5);  //Characteristic velocity
 
end Ex1_9;
//===================================================
